<!DOCTYPE html>
<html lang="hr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detekcija dimenzija na tehničkim nacrtima</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome za ikone -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <!-- Vlastiti CSS -->
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
    <div class="container-fluid">
        <header class="bg-primary text-white text-center py-3 mb-4">
            <h1>Detekcija dimenzija na tehničkim nacrtima</h1>
        </header>

        <div class="row">
            <!-- Lijevi stupac - Upload i kontrole -->
            <div class="col-md-3">
                <div class="card mb-4">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0">Upload dokumenta</h5>
                    </div>
                    <div class="card-body">
                        <form id="uploadForm" enctype="multipart/form-data">
                            <div class="mb-3">
                                <label for="documentFile" class="form-label">Odaberite dokument:</label>
                                <input type="file" class="form-control" id="documentFile" name="documentFile" accept=".pdf,.jpeg,.jpg,.png,.tiff,.bmp">
                            </div>
                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary" id="uploadBtn">
                                    <i class="fas fa-upload me-2"></i>Upload
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="card mb-4">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0">Opcije</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <button class="btn btn-success" id="detectDimensionsBtn" disabled>
                                <i class="fas fa-magic me-2"></i>Automatska detekcija
                            </button>
                            <button class="btn btn-info" id="manualModeBtn" disabled>
                                <i class="fas fa-pencil-alt me-2"></i>Ručno označavanje
                            </button>
                            <button class="btn btn-warning" id="exportBtn" disabled>
                                <i class="fas fa-file-excel me-2"></i>Izvoz u Excel
                            </button>
                            <button class="btn btn-danger" id="resetBtn" disabled>
                                <i class="fas fa-trash me-2"></i>Obriši dokument
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Srednji stupac - Prikaz dokumenta -->
            <div class="col-md-6">
                <div class="card mb-4">
                    <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Prikaz dokumenta</h5>
                        <div>
                            <button class="btn btn-sm btn-light" id="zoomInBtn" disabled>
                                <i class="fas fa-search-plus"></i>
                            </button>
                            <button class="btn btn-sm btn-light" id="zoomOutBtn" disabled>
                                <i class="fas fa-search-minus"></i>
                            </button>
                            <button class="btn btn-sm btn-light" id="resetZoomBtn" disabled>
                                <i class="fas fa-redo"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body p-0 position-relative">
                        <div id="documentViewer" class="document-viewer">
                            <div id="loadingIndicator" class="d-none">
                                <div class="spinner-border text-primary" role="status">
                                    <span class="visually-hidden">Učitavanje...</span>
                                </div>
                                <p class="mt-2">Obrada dokumenta...</p>
                            </div>
                            <div id="noDocumentMessage" class="text-center p-5">
                                <i class="fas fa-file-upload fa-5x text-muted mb-3"></i>
                                <h4>Nije učitan dokument</h4>
                                <p>Molimo uploadajte PDF, JPEG, PNG, TIFF ili BMP datoteku.</p>
                            </div>
                            <div id="viewerContainer" class="d-none">
                                <!-- Ovdje će se prikazati dokument -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Desni stupac - Prepoznate dimenzije -->
            <div class="col-md-3">
                <div class="card mb-4">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0">Prepoznate dimenzije</h5>
                    </div>
                    <div class="card-body p-0">
                        <div class="list-group list-group-flush" id="dimensionsList">
                            <div class="list-group-item text-center p-3" id="noDimensionsMessage">
                                <p class="mb-0">Nema prepoznatih dimenzija</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0">Kategorije</h5>
                    </div>
                    <div class="card-body">
                        <ul class="nav nav-tabs" id="categoryTabs" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="dimensions-tab" data-bs-toggle="tab" data-bs-target="#dimensions" type="button" role="tab">Dimenzije</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="threads-tab" data-bs-toggle="tab" data-bs-target="#threads" type="button" role="tab">Navoji</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="roughness-tab" data-bs-toggle="tab" data-bs-target="#roughness" type="button" role="tab">Hrapavost</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="gdt-tab" data-bs-toggle="tab" data-bs-target="#gdt" type="button" role="tab">GD&T</button>
                            </li>
                        </ul>
                        <div class="tab-content p-3" id="categoryTabsContent">
                            <div class="tab-pane fade show active" id="dimensions" role="tabpanel">
                                <p class="text-center text-muted">Nema prepoznatih dimenzija</p>
                            </div>
                            <div class="tab-pane fade" id="threads" role="tabpanel">
                                <p class="text-center text-muted">Nema prepoznatih navoja</p>
                            </div>
                            <div class="tab-pane fade" id="roughness" role="tabpanel">
                                <p class="text-center text-muted">Nema prepoznate hrapavosti</p>
                            </div>
                            <div class="tab-pane fade" id="gdt" role="tabpanel">
                                <p class="text-center text-muted">Nema prepoznatih GD&T oznaka</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal za ručno dodavanje dimenzije -->
    <div class="modal fade" id="addDimensionModal" tabindex="-1" aria-labelledby="addDimensionModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title" id="addDimensionModalLabel">Dodaj dimenziju</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="dimensionForm">
                        <div class="mb-3">
                            <label for="dimensionText" class="form-label">Tekst dimenzije:</label>
                            <input type="text" class="form-control" id="dimensionText" name="dimensionText" required>
                        </div>
                        <div class="mb-3">
                            <label for="dimensionType" class="form-label">Kategorija:</label>
                            <select class="form-select" id="dimensionType" name="dimensionType" required>
                                <option value="dimension">Dimenzija</option>
                                <option value="thread">Navoj</option>
                                <option value="roughness">Hrapavost</option>
                                <option value="gdt">GD&T</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="dimensionSubType" class="form-label">Podkategorija:</label>
                            <select class="form-select" id="dimensionSubType" name="dimensionSubType">
                                <option value="">-- Odaberite podkategoriju --</option>
                            </select>
                        </div>
                        <input type="hidden" id="dimensionX" name="dimensionX">
                        <input type="hidden" id="dimensionY" name="dimensionY">
                        <input type="hidden" id="dimensionPage" name="dimensionPage" value="1">
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Odustani</button>
                    <button type="button" class="btn btn-primary" id="saveDimensionBtn">Spremi</button>
                </div>
            </div>
        </div>
    </div>

    <!-- JavaScript biblioteke -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/3.4.120/pdf.min.js"></script>
    <script>
        // Inicijalizacija PDFjs
        pdfjsLib.GlobalWorkerOptions.workerSrc = 'https://cdnjs.cloudflare.com/ajax/libs/pdf.js/3.4.120/pdf.worker.min.js';
    </script>
    <script src="js/main.js"></script>
</body>
</html>